function M = blockmatrix(fil, col, rsize, csize)
if nargin == 0 % default constructor
  M.rsizes = [];
  M.csizes = [];
  M.row_regular = 0;
  M.col_regular = 0;
  M.M = [];
  M = class(M, 'blockmatrix');
elseif isa(fil, 'blockmatrix')
  M = fil; % identity function
else
  if isempty(fil)
    M.rsizes = rsize;
    M.row_regular = 0;
  else
    M.rsizes = repmat(rsize, 1, fil);
    M.row_regular = 1;
  end
  
  if isempty(col)
    M.csizes = csize;
    M.col_regular = 0;
  else
    M.csizes = repmat(csize, 1, col);
    M.col_regular = 1;
  end
  M.M = zeros(sum(M.rsizes), sum(M.csizes));
  M = class(M, 'blockmatrix');
end
